/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchHPKernelReader;
import oracle.sysman.oip.oipc.oipch.OipchHPOS;
import oracle.sysman.oip.oipc.oipch.OipchHPPackageReader;
import oracle.sysman.oip.oipc.oipch.OipchHPPatchReader;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPackageFormatException;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchNumKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchPatch;
import oracle.sysman.oip.oipc.oipch.OipchVendor;
import oracle.sysman.oip.oipc.oipch.OipchVersion;

class OipchHPOSCreator
extends OipchOSCreator {
    private static final String OSINFO_FILE = "osinfo.txt";
    private static final String SWLIST_PRODUCT_FILE = "swlist_product.txt";
    private static final String SWLIST_PRODUCT_SCRIPT = "/usr/sbin/swlist -l product 2>/dev/null";
    private static final String SWLIST_BUNDLE_SCRIPT = "/usr/sbin/swlist -l bundle 2>/dev/null";
    private static final String SWLIST_FILESET_SCRIPT = "/usr/sbin/swlist -l fileset 2>/dev/null";
    private static final String PATCHINFO_FILE = "patchinfo.txt";
    private static final String PATCHINFO_SCRIPT = "/usr/sbin/swlist -l patch -a supersedes 2>/dev/null";
    private static final String KERNELINFO_FILE = "kernelinfo.txt";
    private static final String KERNELINFO_SCRIPT = "/usr/sbin/kmtune 2>/dev/null";
    private static final String KERNELINFO_SCRIPT_2 = "/usr/sbin/kctune 2>/dev/null";
    private OipchHPOS m_oHPOS;
    private boolean versionIsNumeric;

    protected OipchHPOSCreator(int iPlatID) {
        super(iPlatID);
    }

    protected OipchOS createOS() {
        this.m_oHPOS = new OipchHPOS();
        this.updateOSInfo();
        this.updateKernelInfo();
        this.updatePackageInfo();
        this.updatePatchInfo();
        return this.m_oHPOS;
    }

    protected void updateOSInfo() {
        this.versionIsNumeric = true;
        this.m_oHPOS.setPlatformID(OiixPlatform.getCurrentPlatform());
        this.m_oHPOS.setOSName(OiixPlatform.getCurrentPlatformOSName());
        String full_ver = OiixPlatform.getCurrentPlatformOSVer();
        if (full_ver.startsWith("B.")) {
            full_ver = full_ver.substring(2);
        }
        this.m_oHPOS.setOSVersion(new OipchVersion(full_ver));
        this.m_oHPOS.setOSVendor(new OipchVendor(System.getProperty("java.vendor")));
        this.m_oHPOS.setOSArch(OiixPlatform.getCurrentPlatformArch());
        if (Character.isLetter(full_ver.charAt(0))) {
            this.versionIsNumeric = false;
        }
    }

    private void updateKernelInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)KERNELINFO_FILE);
        File oFile = new File(sFile);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        File kmtune = new File("/usr/sbin/kmtune");
        File kctune = new File("/usr/sbin/kctune");
        String sCommand = null;
        if (kmtune.exists()) {
            sCommand = "/usr/sbin/kmtune 2>/dev/null>" + sFile;
        } else if (kctune.exists()) {
            sCommand = "/usr/sbin/kctune 2>/dev/null>" + sFile;
        }
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish(sCommand);
        }
        catch (OiilNativeException e) {
            // empty catch block
        }
        if (result != 0) {
            return;
        }
        if (!this.versionIsNumeric) {
            return;
        }
        int nParams = 0;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        while (true) {
            String currentLine = null;
            try {
                currentLine = reader.readLine();
            }
            catch (IOException e) {
                return;
            }
            if (currentLine == null) break;
            ++nParams;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String[] allparams = new String[nParams];
        try {
            reader = new BufferedReader(new FileReader(sFile));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        int cur_param = 0;
        while (true) {
            String currentLine = null;
            try {
                currentLine = reader.readLine();
            }
            catch (IOException e) {
                return;
            }
            if (currentLine == null) break;
            allparams[cur_param] = currentLine;
            ++cur_param;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        OipchKernelInfo oOSKernelInfo = this.m_oHPOS.getKernel();
        OipchHPKernelReader formula = new OipchHPKernelReader(allparams);
        allparams = formula.getValues();
        for (int i = 0; i < allparams.length; ++i) {
            StringTokenizer parmstrtok = new StringTokenizer(allparams[i], " ");
            String word = parmstrtok.nextToken();
            String value = parmstrtok.nextToken();
            OipchNumKernelProperty cur_prop = new OipchNumKernelProperty(word, new Long(value));
            oOSKernelInfo.addProperty(cur_prop);
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void updatePackageInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)SWLIST_PRODUCT_FILE);
        File oFile = new File(sFile);
        if (!this.versionIsNumeric) {
            return;
        }
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = "/usr/sbin/swlist -l product 2>/dev/null>" + sFile;
        String sCommand1 = "/usr/sbin/swlist -l bundle 2>/dev/null>>" + sFile;
        String sCommand2 = "/usr/sbin/swlist -l fileset 2>/dev/null>>" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand1);
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand2);
        }
        catch (OiilNativeException e) {
            // empty catch block
        }
        if (result != 0) {
            return;
        }
        try {
            Collection oPackages = null;
            oPackages = OipchHPPackageReader.readPackageDetails(sFile);
            Iterator iter = oPackages.iterator();
            while (iter.hasNext()) {
                String cur_elem = (String)iter.next();
                String name = cur_elem.substring(0, cur_elem.indexOf(":"));
                String vers = cur_elem.substring(cur_elem.indexOf(":") + 1);
                OipchPackage cur_pkg = OipchPackage.createNewInstance(this.m_iPlatID);
                try {
                    cur_pkg.setProperty("VALUE", name);
                    cur_pkg.setProperty("VERSION", vers);
                }
                catch (OipchIncorrectPackageFormatException e) {
                    // empty catch block
                }
                this.m_oHPOS.addPackage(cur_pkg);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePatchInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)PATCHINFO_FILE);
        File oFile = new File(sFile);
        if (!this.versionIsNumeric) {
            return;
        }
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = "/usr/sbin/swlist -l patch -a supersedes 2>/dev/null>" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            // empty catch block
        }
        if (result != 0) {
            return;
        }
        try {
            Collection oPatches = null;
            oPatches = OipchHPPatchReader.readPatchDetails(sFile);
            Iterator iter = oPatches.iterator();
            while (iter.hasNext()) {
                this.m_oHPOS.addPatch((OipchPatch)iter.next());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getScratchPath() {
        return System.getProperty("oracle.installer.scratchPath", "");
    }
}

